<?php
// this file copies the default cal files to the master files that get xfer to the urebs.
// default files are usually xferred before running an auto calibration

$dir = "/var/www/html/CalFiles/";
$files = [
    "sc-defaults.csv" => "sc.csv",
    "lc-defaults.csv" => "lc.csv",
    "ph-defaults.csv" => "ph.csv",
    "calTrg-defaults.csv" => "calTrg.csv",
];

foreach ($files as $src => $dst) {
    $srcPath = $dir . $src;
    $dstPath = $dir . $dst;

    // Copy the source file
    if (!copy($srcPath, $dstPath)) {
        http_response_code(500);
        echo "Failed to copy $src to $dst";
        exit;
    }

    // Read all lines from the destination file
    $lines = file($dstPath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $cleaned = '';

    foreach ($lines as $line) {
        // Remove everything after //, then strip all spaces and tabs
        $line = preg_replace('/\/\/.*$/', '', $line);
        $line = preg_replace('/\s+/', '', $line);

        // Append to single continuous string
        $cleaned .= $line;
    }

    // Overwrite the destination file with cleaned text (no linefeeds)
    file_put_contents($dstPath, $cleaned);
}

echo "OK";
?>
