<?php
// this file copys the cal files to the master files for xfer to the urebs

$dir = "/var/www/html/CalFiles/";
$files = [
    "sc-cal.csv" => "sc.csv",
    "lc-cal.csv" => "lc.csv",
    "ph-cal.csv" => "ph.csv",
];

foreach ($files as $src => $dst) {
    $srcPath = $dir . $src;
    $dstPath = $dir . $dst;

    // Copy the source file
    if (!copy($srcPath, $dstPath)) {
        http_response_code(500);
        echo "Failed to copy $src to $dst";
        exit;
    }

    // Read all lines from the destination file
    $lines = file($dstPath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $cleaned = '';

    foreach ($lines as $line) {
        // Remove everything after //, then strip all spaces and tabs
        $line = preg_replace('/\/\/.*$/', '', $line);
        $line = preg_replace('/\s+/', '', $line);

        // Append to single continuous string
        $cleaned .= $line;
    }

    // Overwrite the destination file with cleaned text (no linefeeds)
    file_put_contents($dstPath, $cleaned);
}

echo "OK";
?>
